﻿//////////////////////////////////////////////
// LambdaSchedulerTask.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkTasks
#include "../Dll/DllDefines.h"

#include "../Tasks/LambdaTask.h"

#include "SchedulerTask.h"

/// Class ------------------------------------

namespace nkTasks
{
	class DLL_TASKS_EXPORT LambdaSchedulerTask : public SchedulerTask
	{			
		public :
		
			// Constructor, destructor
			LambdaSchedulerTask () noexcept ;
			LambdaSchedulerTask (std::function<void ()> asyncWorkFunction, std::function<void ()> syncFunction) noexcept ;
			virtual ~LambdaSchedulerTask () ;

			// Setters
			void setAsyncWorkFunction (std::function<void()> value) ;
			void setSyncFunction (std::function<void()> value) ;

			// Implement base methods
			virtual void onAsyncWork () override ;
			virtual void onSync () override ;

		private :
		
			// Attributes
			// Used callbacks
			std::function<void()> _asyncWorkFunction ;
			std::function<void()> _syncFunction ;
	} ;
}